% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_sv_evolution}
\alias{plot_sv_evolution}
\title{Plot stochastic volatility evolution}
\usage{
plot_sv_evolution(results, sector = 1)
}
\arguments{
\item{results}{List returned by \code{\link{fit_ou_nonlinear_tmg}}}

\item{sector}{Integer. Sector index to plot. Default 1.}
}
\value{
NULL invisibly. Produces a base R plot as side effect.
}
\description{
Displays the estimated volatility path for a selected sector.
}
\examples{
\donttest{
# 1. Create mock data (Volatility must be positive)
T_obs <- 50
sigma_mat <- matrix(exp(rnorm(T_obs * 2)), nrow = T_obs, ncol = 2)

# 2. Wrap in list structure
results_mock <- list(
  sv = list(
    h_summary = list(
      sigma_t = sigma_mat
    )
  )
)

# 3. Plot sector 1
plot_sv_evolution(results_mock, sector = 1)
}

}
