% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predictive_check.R
\name{posterior_predictive_check}
\alias{posterior_predictive_check}
\alias{print.posterior_predictive_check}
\alias{plot.posterior_predictive_check}
\title{Posterior Predictive Checks}
\usage{
posterior_predictive_check(
  model,
  observed_data,
  n_samples = 1000,
  test_statistics = c("mean", "sd", "median"),
  plot = TRUE,
  alpha = 0.7,
  ...
)

\method{print}{posterior_predictive_check}(x, ...)

\method{plot}{posterior_predictive_check}(x, ...)
}
\arguments{
\item{model}{A fitted brmsfit object}

\item{observed_data}{Vector or matrix of observed data}

\item{n_samples}{Number of posterior predictive samples (default: 1000)}

\item{test_statistics}{Character vector of test statistics to compute.
Options: "mean", "sd", "median", "min", "max", "range", "skewness", "kurtosis"}

\item{plot}{Logical. Whether to generate visualization (default: TRUE)}

\item{alpha}{Numeric. Transparency level for plots (default: 0.7)}

\item{...}{Additional arguments passed to plotting functions}

\item{x}{Object of class \code{posterior_predictive_check} (for print/plot methods).}
}
\value{
Object of class \code{posterior_predictive_check} containing:
\itemize{
\item \code{observed_stats} - Test statistics from observed data
\item \code{replicated_stats} - Test statistics from posterior predictive samples
\item \code{p_values} - Bayesian p-values for each test statistic
\item \code{model} - Original fitted model
\item \code{n_samples} - Number of samples used
}
}
\description{
Conducts posterior predictive checks to assess whether a fitted model
generates data similar to the observed data. This is a key diagnostic
for model adequacy and serves to identify systematic misspecifications.
}
\details{
Posterior predictive checks work by:
\enumerate{
\item Extracting posterior draws from the fitted model
\item For each posterior draw, simulating new data from that parameter set
\item Computing test statistics on both observed and simulated data
\item Comparing the distributions to assess model adequacy
}

A well-fitting model should produce test statistics from simulated
data similar to the observed test statistics. P-values near 0.5
indicate good model fit.
}
