% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchical_convergence.R
\name{hierarchical_convergence}
\alias{hierarchical_convergence}
\alias{print.hierarchical_convergence}
\alias{plot.hierarchical_convergence}
\title{Hierarchical Model Convergence Diagnostics}
\usage{
hierarchical_convergence(
  model,
  group_vars = NULL,
  rhat_threshold = 1.01,
  ess_threshold = 400,
  check_shrinkage = TRUE,
  plot = TRUE,
  ...
)

\method{print}{hierarchical_convergence}(x, ...)

\method{plot}{hierarchical_convergence}(x, ...)
}
\arguments{
\item{model}{A fitted hierarchical Bayesian model (brmsfit, stanfit, or compatible)}

\item{group_vars}{Character vector of grouping variable names (e.g., "subject", "school")}

\item{rhat_threshold}{Numeric. Threshold for R-hat diagnostic (default: 1.01)}

\item{ess_threshold}{Numeric. Minimum effective sample size threshold (default: 400)}

\item{check_shrinkage}{Logical. Whether to assess shrinkage patterns (default: TRUE)}

\item{plot}{Logical. Whether to generate diagnostic plots (default: TRUE)}

\item{...}{Additional arguments passed to plotting functions}

\item{x}{Object of class \code{hierarchical_convergence} (for print/plot methods).}
}
\value{
An object of class \code{hierarchical_convergence} containing:
\item{population_diagnostics}{Diagnostics for population-level (fixed) effects}
\item{group_diagnostics}{Diagnostics for group-level (random) effects}
\item{shrinkage_metrics}{Shrinkage statistics if \code{check_shrinkage = TRUE}}
\item{convergence_summary}{Overall convergence assessment}
\item{warnings}{List of convergence warnings}
\item{model}{Original fitted model}
}
\description{
Performs specialized convergence diagnostics for hierarchical/multilevel
Bayesian models, checking convergence at both group-level and population-level
parameters.
}
\details{
Hierarchical models require special attention to convergence because:
\itemize{
\item Group-level parameters often have slower mixing
\item Variance components can be difficult to estimate
\item Extreme shrinkage may indicate identification problems
}

The function checks:
\itemize{
\item R-hat values for all parameters
\item Effective sample sizes (bulk and tail ESS)
\item Between-chain variance
\item Shrinkage factor (ratio of group SD to pooled SD)
}
}
