% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_vpc_endpoint_service_configuration}
\alias{ec2_modify_vpc_endpoint_service_configuration}
\title{Modify Vpc Endpoint Service Configuration}
\usage{
ec2_modify_vpc_endpoint_service_configuration(
  ServiceId,
  DryRun = NULL,
  PrivateDnsName = NULL,
  RemovePrivateDnsName = NULL,
  AcceptanceRequired = NULL,
  AddNetworkLoadBalancerArn = NULL,
  RemoveNetworkLoadBalancerArn = NULL,
  AddGatewayLoadBalancerArn = NULL,
  RemoveGatewayLoadBalancerArn = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{ServiceId}{Character. The ID of the service.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{PrivateDnsName}{Character. (Interface endpoint configuration) The private DNS name to assign to the endpoint service.[optional]}

\item{RemovePrivateDnsName}{Logical. (Interface endpoint configuration) Removes the private DNS name of the endpoint service.[optional]}

\item{AcceptanceRequired}{Logical. Indicates whether requests to create an endpoint to your service must be accepted.[optional]}

\item{AddNetworkLoadBalancerArn}{List. The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration.[optional]}

\item{RemoveNetworkLoadBalancerArn}{List. The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration....[optional]}

\item{AddGatewayLoadBalancerArn}{List. The Amazon Resource Names (ARNs) of Gateway Load Balancers to add to your service configuration.[optional]}

\item{RemoveGatewayLoadBalancerArn}{List. The Amazon Resource Names (ARNs) of Gateway Load Balancers to remove from your service configuration....[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Modify Vpc Endpoint Service Configuration
}
\section{ServiceId}{

The ID of the
service.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{PrivateDnsName}{

(Interface endpoint
configuration) The private DNS name to assign to the endpoint
service.
}

\section{RemovePrivateDnsName}{

(Interface endpoint configuration) Removes
the private DNS name of the endpoint
service.
}

\section{AcceptanceRequired}{

Indicates whether requests to create an
endpoint to your service must be accepted.
}

\section{AddNetworkLoadBalancerArn}{

The
Amazon Resource Names (ARNs) of Network Load Balancers to add to your
service configuration.
}

\section{RemoveNetworkLoadBalancerArn}{

The Amazon Resource Names
(ARNs) of Network Load Balancers to remove from your service
configuration.
}

\section{AddGatewayLoadBalancerArn}{

The Amazon Resource Names (ARNs) of
Gateway Load Balancers to add to your service
configuration.
}

\section{RemoveGatewayLoadBalancerArn}{

The Amazon Resource Names (ARNs) of
Gateway Load Balancers to remove from your service
configuration.
}

