% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latent_sampling.R
\name{Latent_sample}
\alias{Latent_sample}
\title{Sample from the latent space}
\usage{
Latent_sample(z_mean, z_log_var)
}
\arguments{
\item{z_mean}{TensorFlow tensor or R matrix. The mean values of the latent space.}

\item{z_log_var}{TensorFlow tensor or R matrix. The log-variances of the latent space.}
}
\value{
A TensorFlow tensor of latent samples with the same shape as \code{z_mean}.
}
\description{
Draws a stochastic sample from the latent space of a trained VAE given
the mean (\code{z_mean}) and log-variance (\code{z_log_var}) outputs of the encoder.
This operation implements the \strong{reparameterization trick}:
\deqn{z = \mu + \sigma \odot \epsilon}
where \eqn{\epsilon \sim \mathcal{N}(0, I)}.
}
\details{
The function is used internally within \code{VAE_train()} but can also be
called directly to sample latent points and decode synthetic output.
Typically, \code{z_mean} and \code{z_log_var} are obtained via \code{\link[=encoder_latent]{encoder_latent()}}
and the corresponding weights extracted using \code{\link[=Encoder_weights]{Encoder_weights()}}.
\itemize{
\item The log-variance (\code{z_log_var}) is clamped between -10 and 10 to prevent
numerical overflow or vanishing variance during training.
\item The standard deviation is lower-bounded by \code{1e-3} for stability.
}

This function returns a TensorFlow tensor representing the sampled latent
points. Use \code{as.matrix()} or \code{as.data.frame()} to convert to an R matrix or data frame before passing to
\code{\link[=decoder_model]{decoder_model()}} or other R functions.
}
\examples{
# Suppose encoder_latent() returns z_mean and z_log_var
z_mean    <- matrix(rnorm(10), ncol = 5)
z_log_var <- matrix(rnorm(10), ncol = 5)

\donttest{
if (reticulate::py_module_available("tensorflow")) {
  # Sample from latent space
  z_sample <- Latent_sample(z_mean, z_log_var)

  # Convert to R matrix for decoder prediction
  z_mat <- as.matrix(z_sample)

  # Suppose the computational graph was rebuilt using `decoder_model()`
  # and assigned to an object named `decoder`:
  # decoder_output <- predict(decoder, z_mat)
}
}

}
\seealso{
\code{\link[=VAE_train]{VAE_train()}}, \code{\link[=encoder_latent]{encoder_latent()}}, \code{\link[=Encoder_weights]{Encoder_weights()}}, \code{\link[=decoder_model]{decoder_model()}}
}
