% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjusted.R
\name{useAdjusted}
\alias{useAdjusted}
\title{Switch [[ and Plot to Focus on Adjusted Data, if Available}
\usage{
useAdjusted(argos, fallback = FALSE, debug = 0)
}
\arguments{
\item{argos}{an \code{\linkS4class{argoFloats}} object, as read by \code{\link[=readProfiles]{readProfiles()}}.}

\item{fallback}{a logical value indicating whether to 'fall back' from
adjusted data to raw data for profiles that are in real-time mode.  By
default, \code{fallback} is \code{FALSE}, to focus entirely on
adjusted data.  See \dQuote{Details}.}

\item{debug}{an integer that controls whether debugging information is printed
during processing.  If \code{debug} is 0 or less, then no information is printed.
If it is 1 then minimal overall information is printed.  If it exceeds 1,
then information is printed for each Argo cycle contained in \code{argos}.}
}
\value{
\code{useAdjusted} returns an \code{\linkS4class{argoFloats}} object that is similar to
its first argument, but which is set up so that future calls to
\code{\link{[[,argoFloats-method}} or \code{\link{plot,argoFloats-method}}
will focus on the "adjusted" data stream.
}
\description{
\code{useAdjusted} returns a copy of an \code{\linkS4class{argoFloats}} object
within which the individual
\link[oce:argo-class]{oce::argo} objects may have been modified so that future calls to
\code{\link{[[,argoFloats-method}}
or \code{\link{plot,argoFloats-method}}
will focus with
\emph{adjusted} versions of the data. (Note that this modification cannot
be done for fields that lack adjusted values, so in such cases future
calls to
\code{\link{[[,argoFloats-method}}
or
\code{\link{plot,argoFloats-method}}
work with the unadjusted fields.)
The procedure is done profile by profile and parameter by parameter.
The \code{fallback} argument offers a way to ''fall back'' to unadjusted
values, depending on the data-mode (real-time, adjusted or delayed)
for individual items; see \dQuote{Details}.
}
\details{
There are two cases.  First, if \code{fallback} is \code{FALSE} (which the default)
then the focus switches entirely
to the adjusted data.  This improves the overall reliability of the results,
but at the cost of eliminating real-time data.  This is because the
adjusted fields for real-time data are set to \code{NA} as a matter of policy (see
section 2.2.5 of reference 1).

Wider data coverage is obtained  if \code{fallback} is \code{TRUE}.  In this
case, the focus is shifted to adjusted data \emph{only if} the data-mode for
the individual profiles is \code{A} or \code{D}, indicating either Adjusted or
Delayed mode. Any profiles that are of the \code{R} (Realtime) data-mode are
left unaltered. This blending of adjusted and unadjusted data offers
improved spatial and temporal coverage, while reducing the overall
data quality, and so this approach should be used with caution. For more
on this function see section 3.4 of Kelley et. al (2021).
}
\examples{
library(argoFloats)
file <- "SD5903586_001.nc"
raw <- readProfiles(system.file("extdata", file, package = "argoFloats"))
adj <- useAdjusted(raw)
# Autoscale with adjusted values so frame shows both raw and adjusted.
plot(adj, which = "profile", profileControl = list(parameter = "oxygen"), pch = 2)
points(raw[[1]][["oxygen"]], raw[[1]][["pressure"]], pch = 1)
legend("bottomright", pch = c(2, 1), legend = c("Raw", "Adjusted"))

}
\references{
\enumerate{
\item Argo Data Management Team. "Argo User's Manual V3.4,"
January 20, 2021. \verb{https://archimer.ifremer.fr/doc/00187/29825/}
\item Kelley, D. E., Harbin, J., & Richards, C. (2021). argoFloats: An R package for analyzing
Argo data. Frontiers in Marine Science, (8), 636922.
\doi{10.3389/fmars.2021.635922}
}
}
\author{
Dan Kelley, Jaimie Harbin and Clark Richards
}
