% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-estimates.R
\name{get_layer_estimates}
\alias{get_layer_estimates}
\title{Get Estimates}
\usage{
get_layer_estimates(x, token = arc_token())
}
\arguments{
\item{x}{an object of class \code{FeatureLayer}, \code{Table}, or \code{ImageServer}.}

\item{token}{an \code{httr2_token} as created by \code{auth_code()} or similar}
}
\value{
A named list containing all estimate info. If \code{extent} is present,
it is available as an object of class \code{bbox}.
}
\description{
Get Estimates
}
\examples{
\dontrun{
if (identical(Sys.getenv("NOT_CRAN"), "true")) {
furl <- paste0(
  "https://services.arcgis.com/P3ePLMYs2RVChkJx/ArcGIS/rest/services/",
  "USA_Counties_Generalized_Boundaries/FeatureServer/0"
)

county_fl <- arc_open(furl)
get_layer_estimates(county_fl)
}
}
}
\references{
\href{https://developers.arcgis.com/rest/services-reference/enterprise/get-estimates-feature-service-layer-.htm}{ArcGIS REST Doc}
}
