% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc-select.R
\name{arc_select}
\alias{arc_select}
\title{Query a Feature Service}
\usage{
arc_select(
  x,
  ...,
  fields = NULL,
  where = NULL,
  crs = sf::st_crs(x),
  geometry = TRUE,
  filter_geom = NULL,
  predicate = "intersects",
  n_max = Inf,
  page_size = NULL,
  token = arc_token()
)
}
\arguments{
\item{x}{an object of class \code{FeatureLayer}, \code{Table}, or \code{ImageServer}.}

\item{...}{additional query parameters passed to the API.}

\item{fields}{a character vector of the field names that you wish to be
returned. By default all fields are returned.}

\item{where}{a simple SQL where statement indicating which features should be
selected.}

\item{crs}{the spatial reference to be returned. If the CRS is different than
the CRS for the input \code{FeatureLayer}, a transformation will occur
server-side. Ignored if x is a \code{Table}.}

\item{geometry}{default \code{TRUE}. If geometries should be returned. Ignored for
\code{Table} objects.}

\item{filter_geom}{an object of class \code{bbox}, \code{sfc} or \code{sfg} used to filter
query results based on a predicate function.}

\item{predicate}{Spatial predicate to use with \code{filter_geom}. Default
\code{"intersects"}. Possible options are \code{"intersects"}, \code{"contains"},
\code{"crosses"},  \code{"overlaps"},  \code{"touches"}, and \code{"within"}.}

\item{n_max}{the maximum number of features to return. By default returns
every feature available. Unused at the moment.}

\item{page_size}{the maximum number of features to return per request. Useful when requests return a 500 error code. See Details.}

\item{token}{an \code{httr2_token} as created by \code{auth_code()} or similar}
}
\value{
An sf object, or a data.frame
}
\description{
\code{\link[=arc_select]{arc_select()}} takes a \code{FeatureLayer}, \code{Table}, of \code{ImageServer} object and
returns data from the layer as an \code{sf} object or \code{data.frame} respectively.
}
\details{
See \href{https://developers.arcgis.com/rest/services-reference/enterprise/query-feature-service-layer-.htm#GUID-BC2AD141-3386-49FB-AA09-FF341145F614}{reference documentation} for possible arguments.

\code{FeatureLayers} can contain very dense geometries with a lot of coordinates.
In those cases, the feature service may time out before all geometries can
be returned. To address this issue, we can reduce the number of features
returned per each request by reducing the value of the \code{page_size} parameter.

\code{arc_select()} works by sending a single request that counts the number of
features that will be returned by the current query. That number is then used
to calculate how many "pages" of responses are needed to fetch all the results.
The number of features returned (page size) is set to the \code{maxRecordCount}
property of the layer by default. However, by setting \code{page_size} to be
smaller than the \code{maxRecordCount} we can return fewer geometries per page and
avoid time outs.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
# define the feature layer url
furl <- paste0(
  "https://services3.arcgis.com/ZvidGQkLaDJxRSJ2/arcgis/rest",
  "/services/PLACES_LocalData_for_BetterHealth/FeatureServer/0"
)

flayer <- arc_open(furl)

arc_select(
  flayer,
  fields = c("StateAbbr", "TotalPopulation")
)

arc_select(
  flayer,
  fields = c("OBJECTID", "PlaceName"),
  where = "TotalPopulation > 1000000"
)
}
}
