% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth.R
\name{ag}
\alias{ag}
\alias{weight_gain}
\title{Absolute Growth (AG)}
\usage{
ag(ibw, fbw)

weight_gain(ibw, fbw)
}
\arguments{
\item{ibw}{numeric; value providing the initial bodyweight in grams.}

\item{fbw}{numeric; value providing the final bodyweight in grams.}
}
\value{
returns a numeric value that is the AG.
}
\description{
A function that calculates the Absolute Growth (AG), also denoted as
Absolute Weight Gain (AWG) based on the Initial Body weight (IBW;
ibw) in gram (g) and the Final Body Weight (FBW; fbw)
in gram (g).
}
\examples{
data(weight2)
dplyr::mutate(weight2, AG = ag(ibw_g, fbw_g))

}
\references{
Lugert, V., Thaller, G., Tetens, J., Schulz, C., & Krieter, J.
(2016): A review on fish growth calculation: multiple functions in fish
production and their specific application. Reviews in Aquaculture, 8,
p.30–42.
}
\author{
Anıl Axel Tellbüscher
}
