% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digestibility.R
\name{adc_nut}
\alias{adc_nut}
\title{ADC of a nutrient (ADCnut)}
\usage{
adc_nut(std_diet, std_feces, nut_diet, nut_feces)
}
\arguments{
\item{std_diet}{numeric; value resembling the inclusion rate of
standard in the experimental diet given to the livestock.}

\item{std_feces}{numeric; value resembling the inclusion rate of
standard in the feces recovered during the digestibility trial.}

\item{nut_diet}{numeric; value representing the inclusion rate of the
target nutrient in the diet.}

\item{nut_feces}{numeric; value representing the inclusion rate of the
target nutrient in the feces.}
}
\value{
returns a single numeric value in the interval [0, 1] which is the
relative ADC for a single nutrient in the diet. If the value is not within
the interval, an additional warning is returned.
}
\description{
Function to calculate the Apparent Digestibility Coefficient of a nutrient
in the dry matter fraction of a compound diet.
}
\examples{
# 0.4 g/g (40\%) CP on dry matter basis in feed
# 0.1 g/g (10\%) CP on dry matter basis in feces
# 0.010 g/g (1\%) digestibility standard in feed
# 0.045 g/g (4.5\%) digestibility standard in feces

adc_nut(nut_diet = 0.4, nut_feces = 0.1, 
        std_diet = 0.01, std_feces = 0.045)

}
\references{
Bureau, D.P., & Hua, K. (2006): Letter to the Editor of
Aquaculture. Aquaculture, 252, p.103–105.

Cho, C.Y., Slinger, S.J., & Bayley, H.S. (1982): Bioenergetics 
of salmonid fishes: energy intake, expenditure and productivity. Comp. 
Biochem. Physiol. 73B, p.25–41.
}
\author{
Anıl Axel Tellbüscher
}
