% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readClusterDesc.R
\name{readClusterDesc}
\alias{readClusterDesc}
\alias{readClusterResDesc}
\alias{readClusterSTDesc}
\title{Import clusters description}
\usage{
readClusterDesc(opts = simOptions(), dot_format = TRUE)

readClusterResDesc(opts = simOptions(), dot_format = TRUE)

readClusterSTDesc(opts = simOptions(), dot_format = TRUE)
}
\arguments{
\item{opts}{list of simulation parameters returned by the function
\code{\link{setSimulationPath}}}

\item{dot_format}{\code{logical} default TRUE to return \code{character} with "valid" format (see \code{\link[=make.names]{make.names()}})}
}
\value{
A \code{data.table} with one line per cluster.

Columns are displayed using the 3 key columns (\emph{area}, \emph{cluster}, \emph{group}).
The rest of the properties are displayed according to cluster type
("thermal", "renewable" or "st-storages").

key columns:

\item{area}{Name of the area containing the cluster}
\item{cluster}{Name of the cluster}
\item{group}{Type of cluster (gaz, nuclear, etc.)}

By default, the function reads the cluster description of the default antares
study. You can use the argument \code{opts} to specify another study.

\code{readClusterDesc} : read thermal clusters

\code{readClusterResDesc} : read renewable clusters (Antares >= V8.1)

\code{readClusterSTDesc} : read st-storage clusters (Antares >= V8.6)

If you have no clusters properties, \verb{Null data.table (0 rows and 0 cols)} is returned.
}
\description{
This function reads in the input files of an antares study the
properties of each cluster.

Be aware that clusters descriptions are read
in the input files so they may have changed since a simulation has been run.
}
\section{Warning}{

You have now two format output to display input properties.
Default is format uses by operating team, eg \code{min.down.time}.
Other format is according to antares simulator, eg \code{min-down-time}.

All properties are returned with default values according to Antares Study version.
}

\examples{

\dontrun{

# Default format with "dot separator"

# thermal
readClusterDesc()

# renewable
readClusterResDesc()

# st-storage
readClusterSTDesc()

# Antares Simulator format 

#' # thermal
readClusterDesc(dot_format = FALSE)

# renewable
readClusterResDesc(dot_format = FALSE)

# st-storage
readClusterSTDesc(dot_format = FALSE)


# By default, the function reads cluster descriptions for the default study,
# but it is possible to specify another study with parameter "opts"
sim1 <- setSimulationPath()

#[... code that modifies the default antares study]

readClusterDesc(sim1)

}

}
