% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DKI_v2.R
\name{DKI2}
\alias{DKI2}
\title{Calculates DKI (v2)}
\usage{
DKI2(AMBI, H, N, psal)
}
\arguments{
\item{AMBI}{AMBI, the AZTI Marine Biotic Index, calculated using \code{\link[=AMBI]{AMBI()}}}

\item{H}{H', the Shannon diversity index, calculated using \code{\link[=Hdash]{Hdash()}}}

\item{N}{number of individuals - generated by both \code{\link[=AMBI]{AMBI()}} and \code{\link[=Hdash]{Hdash()}}}

\item{psal}{salinity}
}
\value{
\code{DKI} index value
}
\description{
\code{\link[=DKI2]{DKI2()}} calculate a salinity-normalised version of the Danish quality
index (DKI) \href{#references}{(Carstensen et al., 2014)}

The \emph{DKI} index is based on AMBI and can only be calculated after first calculating
\emph{AMBI}, the AZTI Marine Biotic Index, and \emph{H'}, the Shannon diversity index.
Both indices are included in output from the function \code{\link[=AMBI]{AMBI()}}.

This function uses linear relationships between salinity and limits for \code{AMBI}
and \code{Hdash} to normalise the index. This is done to account for expected
lower species diversity in regions with lower salinity.

Since the index is normalised to salinity, the function also requires
measured or estimated salinity \code{psal} as an argument.

#' @references
Carstensen, J., Krause-Jensen, D., Josefson, A. (2014). "Development and testing of tools for intercalibration of phytoplankton, macrovegetation and benthic fauna in Danish coastal areas." Aarhus University, DCE – Danish Centre for Environment and Energy, 85 pp. \emph{Scientific Report from DCE – Danish Centre for Environment and Energy} No. 93.
\url{https://dce2.au.dk/pub/SR93.pdf}
}
\details{
The \code{\link[=AMBI]{AMBI()}} and \code{\link[=Hdash]{Hdash()}} functions take a dataframe of observations as an
argument. The \emph{DKI} functions, \code{\link[=DKI2]{DKI2()}} and \code{\link[=DKI]{DKI()}}, do \emph{not} take a dataframe
as an argument. Instead they take values of the input parameters, either
single values or as vectors.

To calculate DKI for a dataframe of \code{AMBI} values, it could be called from
e.g. within a \code{\link[dplyr:mutate]{dplyr::mutate()}} function call. See the examples below.
}
\examples{

# Simple example

DKI2(AMBI = 1.61, H = 2.36, N = 25, psal = 21.4)


# ------ Example workflow for calculating DKI (v2) from species counts ----

# calculate AMBI index
dfAMBI <- AMBI(test_data, by = c("station"), var_rep = "replicate")[["AMBI"]]

# show AMBI results
dfAMBI

# add salinity values - these are realistic but invented values
dfAMBI <- dplyr::mutate(dfAMBI, psal=ifelse(station == 1, 21.3, 26.5))

# calculate DKI from AMBI results
dfAMBI <- dplyr::mutate(dfAMBI, DKI=DKI2(AMBI, H, N, psal))

}
\seealso{
\itemize{
\item \code{\link[=DKI]{DKI()}} calculate DKI using the original method
\item \code{\link[=AMBI_sal]{AMBI_sal()}} minimum AMBI for normalisation \emph{= f(salinity)}
\item \code{\link[=H_sal]{H_sal()}} maximum H' for normalisation \emph{= f(salinity)}
}
}
