test_that("check warning when data are tied", {
  X <- c(6.2, 3.5, NA, 7.6, 7.6)
  Y <- c(NA, NA, -0.5, -1.7)
  expect_warning(abwm.test(X,Y))
})


test_that("check bounds of the AB test Statistic", {
  X <- c(6.2, 3.5, NA, 7.6, 9.2)
  Y <- c(NA, NA, -0.5, -1.7)
  RES <- abwm.test(X,Y)
  RES_enumerates <- EnumeratingAnsairiBradley(X,Y)
  # minimum possible AB test statistic
  expect_equal(RES$bounds.statistic[1], RES_enumerates[1])
  # maximum possible AB test statistic
  expect_equal(RES$bounds.statistic[2], RES_enumerates[2])
})


test_that("check p-value of the AB test without missing: two sided", {
  set.seed(0)
  X <- rnorm(100,0,1)
  Y <- rnorm(100,0,2)
  expect_equal(abwm.test(X,Y)$p.value, ansari.test(X,Y)$p.value)
})


test_that("check p-value of the AB test without missing: less", {
  set.seed(0)
  X <- rnorm(100,0,1)
  Y <- rnorm(100,0,2)
  expect_equal(abwm.test(X,Y, 'less')$p.value, ansari.test(X,Y, 'less')$p.value)
})


test_that("check p-value of the AB test without missing: greater", {
  set.seed(0)
  X <- rnorm(100,0,1)
  Y <- rnorm(100,0,2)
  expect_equal(abwm.test(X,Y, 'greater')$p.value,
               ansari.test(X,Y, 'greater')$p.value)
})
