# Compute the minimum possible Ansari-Bradley test statistic with missing data
MinAnsariBradley <- function(X,Y){
  n <- length(X)
  m <- length(Y)
  N <- n + m
  ObsX <- X[!is.na(X)]
  n_prime <- length(ObsX)
  ObsY <- Y[!is.na(Y)]
  m_prime <- length(ObsY)
  PartialRankX <- rank(c(ObsX,ObsY))[1:n_prime]  ### ranks of samples in observed X among all observed samples
  PartialABT <- AnsariBradley(PartialRankX, (n_prime + m_prime))
  a = max((m-n_prime-2*m_prime+1)/2,0)
  b = min((m+n_prime+1)/2, m-m_prime)
  c = max((m-n_prime-2*m_prime)/2,0)
  d = min((m+n_prime)/2,m-m_prime)
  if ( (N%%2!=0)&((n-n_prime)%%2==0)  ) {
    #n-n_prime is even
    res <- PartialABT + (n^2 - n_prime^2)/4 + min(sapply(seq(a,b), function(k) f(ObsX, ObsY, m, k)))
  }else if( (N%%2!=0)&((n-n_prime)%%2!=0) ){
    res <- PartialABT + (n^2 - n_prime^2 - 1)/4 + min(sapply(seq(c,d), function(k) f(ObsX, ObsY, m, k)))
  }else if( (N%%2==0)&((n-n_prime)%%2!=0) ){
    res <- PartialABT + (n^2 - n_prime^2 + 1)/4 + min(sapply(seq(a,b), function(k) f(ObsX, ObsY, m, k)))
  }else if( (N%%2==0)&((n-n_prime)%%2==0) ){
    res <- PartialABT + (n^2 - n_prime^2)/4 + min(sapply(seq(c,d), function(k) f(ObsX, ObsY, m, k)))
  }
  return(res)
}
