% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_operators.R
\name{generate_tooltip_text}
\alias{generate_tooltip_text}
\title{Generate HTML Tooltip Text}
\usage{
generate_tooltip_text(data, labels_df, tooltip_vars, type)
}
\arguments{
\item{data}{A data.frame with the source data.}

\item{labels_df}{A data.frame used by \code{get_label()} to find variable labels.}

\item{tooltip_vars}{A character vector of column names to include in the tooltip.}

\item{type}{A character string specifying the label type for \code{get_label()}.}
}
\value{
A character vector of formatted HTML tooltip strings.
}
\description{
Generate HTML Tooltip Text
}
\details{
Creates a character vector of HTML tooltips for each row of a data frame,
suitable for use with \code{ggplotly}.
The output vector of this function should be added to original plotting data as a column,
which then can be used as tooltip argument in the plotting function.
}
\examples{
# Sample data
my_data <- data.frame(
  USUBJID = c("Subject-01", "Subject-02"),
  DOSE = c(100, 200),
  RESPONSE = c(5.4, 8.1)
  )

my_labels <- data.frame(
  Dataset = "ADNCA",
  Variable = "USUBJID",
  Label = "Unique Subject ID"
  ) # Dummy labels object

vars_to_show <- c("USUBJID", "DOSE", "RESPONSE")

# Generate the tooltip text vector
tooltips <- generate_tooltip_text(my_data, my_labels, vars_to_show, "ADNCA")
my_data$tooltip <- tooltips

}
