% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose_profile_duplicates.R
\name{dose_profile_duplicates}
\alias{dose_profile_duplicates}
\title{Create duplicates in concentration data with Pre-dose and Last Values for Dosing Cycles}
\usage{
dose_profile_duplicates(
  conc_data,
  groups = c("USUBJID", "DOSNOA", "PARAM"),
  dosno = "DOSNOA",
  arrlt = "ARRLT",
  afrlt = "AFRLT",
  nrrlt = "NRRLT",
  nfrlt = "NFRLT"
)
}
\arguments{
\item{conc_data}{A data frame containing concentration data.}

\item{groups}{A character vector of column names to use for grouping
(e.g., c("USUBJID", "PARAM", "DOSNOA")).}

\item{dosno}{Column name for the dose number (default: "DOSNOA").}

\item{arrlt}{Column name for time from the most recent dose.}

\item{afrlt}{Column name for time from the first dose.}

\item{nrrlt}{Column name for the numeric relative time.}

\item{nfrlt}{Column name for the nominal relative time.}
}
\value{
A data frame with adjusted concentration data, including:
\itemize{
\item Duplicated pre-dose values assigned to the previous dose.
\item Duplicated last values assigned to the next dose if pre-dose values are missing,
filtered so only samples within 4 hours of the next dose are included.
\item Sorted by the grouping variables and relative time.
}
}
\description{
This function duplicates and adjusts concentration data to ensure all dosing cycles have
complete pre-dose and last concentration values. It is designed for use in pharmacokinetic
analyses where dosing intervals and concentration values need to be aligned for each dose.
}
\examples{
# Example usage
conc_data <- data.frame(
USUBJID = c("001", "001", "001", "001", "001", "001", "001", "001", "001", "001"),
AVAL = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
DOSNOA = c(1, 1, 1, 2, 2, 2, 2, 3, 3, 3),
ARRLT = c(-1, 0, 1, -1, 0, 1, 2, 0, 1, 2),
AFRLT = c(-1, 0, 1, 2, 3, 4, 5, 6, 7, 8),
NRRLT = c(-1, 0, 1, -1, 0, 1, 2, 0, 1, 2),
NFRLT = c(-1, 0, 1, 2, 3, 4, 5, 6, 7, 8)
)
result <- dose_profile_duplicates(conc_data,
                            groups = c("USUBJID", "DOSNOA"), dosno = "DOSNOA")

}
