% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_mapping.R
\name{apply_mapping}
\alias{apply_mapping}
\title{Apply UI-Based Column Mapping to a Dataset}
\usage{
apply_mapping(
  dataset,
  mapping,
  desired_order,
  silent = TRUE,
  req_mappings = c("USUBJID", "AFRLT", "NFRLT", "ARRLT", "NRRLT", "PCSPEC", "ROUTE",
    "AVAL", "STUDYID", "ATPTREF", "AVALU", "RRLTU", "DOSEU", "PARAM")
)
}
\arguments{
\item{dataset}{A data frame containing the raw data to be transformed.}

\item{mapping}{A named list of column mappings.}

\item{desired_order}{A character vector specifying the desired column order
in the output dataset.}

\item{silent}{Boolean, whether to print message with applied mapping.
Defaults to \code{TRUE}.}

\item{req_mappings}{A character vector indicating the names of the mapping object
that must always be populated}
}
\value{
A transformed data frame with:
\itemize{
\item Renamed columns according to user mappings
\item Created columns for mapped non-existent variables (e.g., \code{mg/L} in \code{AVALU})
\item Created columns for unmapped required variables (e.g., \code{ADOSEDUR})
\item Ordered columns as specified
\item Labels applied to columns (via \code{apply_labels()})
\item Concentration duplicates removed based on key identifiers:
\code{AFRLT}, \code{STUDYID}, \code{PCSPEC}, \code{DOSETRT}, \code{USUBJID}, and \code{PARAM}
}
}
\description{
This function takes a dataset and applies user-specified column mappings
provided through a Shiny \code{input} object. It renames columns based
on the selected mappings, handles special cases such as \code{ADOSEDUR},
updates units for key variables, applies labels,
and removes detected duplicate concentration records.
}
\details{
\itemize{
\item Validates that all required columns are mapped and no duplicates exist.
\item If \code{ADOSEDUR} is not mapped, it is assigned a value of \code{0}.
\item Removes concentration data duplicates using all columns except \code{ARRLT}, \code{NRRLT},
and \code{ATPTREF}.
}
}
