% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DownloadRadolanFromDWD.R
\name{DownloadRadolanFromDWD}
\alias{DownloadRadolanFromDWD}
\title{Downloads daily precipitation data (RADOLAN) from DWD OpenData for a
given AOI and time span. Depending on the date range, it uses either
the "recent" or "historical" RADOLAN archives. Data are clipped to the
AOI and saved as shapefiles, one per day of year (DOY).}
\usage{
DownloadRadolanFromDWD(
  target_path = NA,
  target_site = NA,
  start_date = NA,
  end_date = NA
)
}
\arguments{
\item{target_path}{Path to download and save shapefile for every DOY within timespan of interest}

\item{target_site}{Path to shapefile containing your AOI (string).}

\item{start_date}{start date of interest (e.g.: "2021-01-01"). If empty, default is 1st Jan of recent year.}

\item{end_date}{end date of interest (e.g.: "2021-12-31"). If empty, default is yesterday.}
}
\value{
Shapefiles for every DOY containing precipitation data for your AOI.
}
\description{
Downloads daily precipitation data (RADOLAN) from DWD OpenData for a
given AOI and time span. Depending on the date range, it uses either
the "recent" or "historical" RADOLAN archives. Data are clipped to the
AOI and saved as shapefiles, one per day of year (DOY).
}
