% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReFH.R
\name{ReFH}
\alias{ReFH}
\title{Revitalised Flood Hydrograph Model (ReFH)}
\usage{
ReFH(
  CDs = NULL,
  Depth = NULL,
  Duration = NULL,
  Timestep = NULL,
  RainProfile = "FSR",
  PlotTitle = NULL,
  RPa = NULL,
  alpha = FALSE,
  WaterBalance = FALSE,
  Season = NULL,
  AREA = NULL,
  TP = NULL,
  BR = NULL,
  BL = NULL,
  Cmax = NULL,
  Cini = NULL,
  BFini = NULL,
  Rain = NULL,
  UHShape = "KT",
  UrbanLoss = FALSE,
  Loss = NULL,
  LossCini = NULL
)
}
\arguments{
\item{CDs}{catchment descriptors derived from either GetCDs or ImportCD}

\item{Depth}{a numeric value. The depth of rainfall used as input in the estimation of a design hydrograph. The default, when Depth = NULL, is a two year rainfall.}

\item{Duration}{a numeric value. A duration (hrs) for the design rainfall}

\item{Timestep}{a numeric value. A user defined data interval. The default changes depending on the estimated time to peak to formulate a sensible looking result. This will need updating if the Rain argument is used.}

\item{RainProfile}{This is a choice of the temporal rainfall pattern. The default is the FSR profile. However, you can also choose a randomly generated profile with a different loading. The choices are: "Centre", "Back", "Front", "Uniform", or "Random". The latter randomly chooses between the former four.}

\item{PlotTitle}{a character string. A user defined title for the ReFH plot}

\item{RPa}{return period for alpha adjustment. This is only for the purposes of the alpha adjustment, it doesn't change the rainfall input}

\item{alpha}{a logical argument with default TRUE. If TRUE the alpha adjustment is applied based on RPa. If FALSE, no alpha adjustment is made}

\item{WaterBalance}{A logical argument with a default of FALSE. If it is TRUE, the water balance is checked, if it is not voilated the BR parameter is as per the default estimate. Otherwise BR is set as a function of the proportion of net-rain to rain (NetProp) as BR = (1/NetProp)-1.}

\item{Season}{a choice of "summer" or "winter". The default is "summer" in urban catchments (URBEXT2015 > 0.03) and "winter" in rural catchments}

\item{AREA}{numeric. Catchment area in km2.}

\item{TP}{numeric. Time to peak parameter (hours)}

\item{BR}{numeric. Baseflow recharge parameter. If BR is set to zero, a constant baseflow of BFini is the result.}

\item{BL}{numeric. Baseflow lag parameter (hours)}

\item{Cmax}{numeric. Maximum soil moisture capacity parameter (mm)}

\item{Cini}{numeric. Initial soil moisture content (mm)}

\item{BFini}{numeric. Initial baseflow (m3/s)}

\item{Rain}{numeric. User input rainfall. A numeric vector. If this is used, the Timestep argument needs to be applied.}

\item{UHShape}{User choice of unit hydrograph shape. The default is "KT" (Kinked triangle). The other options are FSR and Gamma.}

\item{UrbanLoss}{Logical with a default of FALSE. If this is TRUE, the urban loss model is applied.}

\item{Loss}{A value between 0 and 1. This overrides the default loss model which uses Cini and Cmax and instead NetRain is calculated as Rain * (1-Loss).}

\item{LossCini}{A value between 0 and 1. This Adjusts the Cini value according to a user input loss. i.e. if the user wants 70 percent loss and inputs 0.7, the Cini will be updated to ensure this is the overall loss. i.e. Cini will be calculated as Cini = ((1-LossCini)-(Depth/(2Cmax))) * Cmax.}
}
\value{
A list with two elements, and a plot. First element of the list is a data.frame of parameters, initial conditions and the catchment area. The second is a data.frame with columns Rain, NetRain, Runoff, Baseflow, and TotalFlow. If the scale argument is used a numeric vector containing the scaled hydrograph is returned instead of the results dataframe. The plot is of the ReFH output, with rainfall, net-rainfall, baseflow, runoff and total flow. If the scaled argument is used, a scaled hydrograph is plotted.
}
\description{
Provides outputs for the ReFH model from catchment descriptors or user defined inputs.
}
\details{
As default this function is the ReFH model as described in the Flood Estimation Handbook Supplementary Report No.1 (2007). However, optional extras have been added such as an urban loss model and an option to ensure a water balance if it has been violated. The urban loss model is applied with default urban parameters (IF = 0.7, DS = 0.5, IRF = 0.4) and is described in the Wallingford Hydrosolutions report "ReFH2 Science Report Closing a Water Balance" (2019). The method to derive design rainfall profiles is described in the Flood Estimation Handbook (1999), volume 2. This has been slightly adjusted so that even profiles are possible. Users can also input their own rainfall with the 'Rain' argument. As a default, when catchment descriptors (CDs) are provided the ReFH function uses catchment descriptors to estimate the parameters of the ReFH model and an approximate two-year rainfall for the critical duration. If a parameter argument is used for one or more of the parameters, then these overwrite the CD derived parameters. This ReFH function is recommended for analysing the plausible catchment response to an input of rainfall. For this reason, and as noted, multiple additional features are available. The user can change components such as the unit hydrograph and the loss. The WaterBalance option can be applied to ensure it is not violated. Also, the baseflow component can be set as a constant (as opposed to a function of the runoff) by setting BR to zero. The rainfall can also be changed by choosing a range of different randomised profiles.
}
\examples{
# Get CDs and apply the ReFH function
cds_203018 <- GetCDs(203018)
ReFH(cds_203018)

# Apply the ReFH function with a user defined initial baseflow
ReFH(cds_203018, BFini = 6)

}
\author{
Anthony Hammond
}
