% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{tests}
\alias{tests}
\title{tests}
\usage{
tests(
  y,
  parts = 1/3,
  nCoef = min(25, length(x)/4),
  nPar = 0,
  s = frequency(y),
  avoid = 16
)
}
\arguments{
\item{y}{a vector, ts or tsibble object}

\item{parts}{proportion of sample to include in ratio of variances test}

\item{nCoef}{number of autocorrelation coefficients to estimate}

\item{nPar}{number of parameters in a model if y is a residual}

\item{s}{seasonal period, number of observations per year}

\item{avoid}{number of observations to avoid at beginning of sample to
eliminate initial effects}
}
\value{
Table with all test results
}
\description{
Tests on a time series
}
\details{
Multiple tests on a time series, including summary statistics,
autocorrelation, Gaussianity and heteroskedasticity,
}
\examples{
tests(AirPassengers)
}
\seealso{
\code{\link{colMedians}}, \code{\link{rowMedians}},
         \code{\link{sumStats}}, \code{\link{gaussTest}}, \code{\link{ident}},
         \code{\link{cusum}}, \code{\link{varTest}}, \code{\link{conv}},
         \code{\link{armaFilter}}, \code{\link{dif}}, \code{\link{roots}},
         \code{\link{zplane}}, \code{\link{acft}}, \code{\link{slide}},
         \code{\link{plotSlide}}, \code{\link{Accuracy}}, \code{\link{tsDisplay}},
         \code{\link{size}}
}
\author{
Diego J. Pedregal
}
