% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myerson.R
\name{myerson}
\alias{myerson}
\title{Myerson value}
\usage{
myerson(
  characteristic_func,
  graph_edges,
  n_players = 0,
  method = "exact",
  n_rep = 10000,
  echo = TRUE
)
}
\arguments{
\item{characteristic_func}{The valued function defined on the subsets of the number
of players. It can be provided as a vector or as a function.}

\item{graph_edges}{Edges of the communication graph of the game. It must be
a \code{list} of pairs indicating the connected players.}

\item{n_players}{Only used if \code{characteristic_func} is a \code{function}.
The number of players in the game.}

\item{method}{Method used to  calculate the Myerson value. Valid methods are:
\code{exact} for the exact calculation or \code{appro} for approximated polynomial
calculation based on sampling proposed.}

\item{n_rep}{Only used if \code{method} is \code{appro}. The number of
iterations to perform in the approximated calculation.}

\item{echo}{Only used if \code{method} is \code{appro}. Show progress of the
approximated calculation.}
}
\value{
The Myerson value for each player.
}
\description{
Calculate the Myerson value in a communication game.
}
\examples{
characteristic_func <- c(
1, 2, 0, 3,
3, 1, 4, 2, 5, 3,
3, 6, 4, 5,
15
)
graph_edges <- list(c(1, 2), c(2, 4))
myerson(characteristic_func, graph_edges, method = "exact")
myerson(characteristic_func, graph_edges, method = "appro", n_rep = 1000)

v <- function(S) {
  if (length(S) == 2) {
    return(1)
   }
   return(0)
}
n <- 3
graph_edges <- list(c(1, 2))
myerson(v, graph_edges, n_players = n, method = "exact")
myerson(v, graph_edges, n_players = n, method = "appro", n_rep = 2000)

}
