% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/potentialoutcome_numX.R
\name{potentialoutcome_numX}
\alias{potentialoutcome_numX}
\title{Estimation of Potential Outcomes Based on the Universal Approach (for Numeric Exposure)}
\usage{
potentialoutcome_numX (xx, xm, data, X, M, Y,
m_type, y_type, m_model, y_model)
}
\arguments{
\item{xx}{a counterfactual value for exposure, directly affecting the outcome. Equals 1 in the treatment group,
equals 0 in the control group.}

\item{xm}{a counterfactual value for exposure, directly affecting the mediator. Equals 1 in the treatment group,
equals 0 in the control group.}

\item{data}{a dataframe used for the above models in the mediation analysis.}

\item{X}{a character variable of the exposure's name.}

\item{M}{a character variable of the mediator's name.}

\item{Y}{a character variable of the outcome's name.}

\item{m_type}{a character variable of the mediator's type.}

\item{y_type}{a character variable of the outcome's type.}

\item{m_model}{a fitted model object for the mediator.}

\item{y_model}{a fitted model object for the outcome.}
}
\value{
This function returns a value of the potential outcome.
}
\description{
This function realizes the main algorithm of the universal approach to
estimate potential outcomes with observed data. Different potential outcomes
can be estimated by different combinations of the input parameters \code{xx} and \code{xm}.

This is an internal function, automatically called by the function \code{\link{SingleEstimation}}.
}
\details{
This function is called when the exposure is a numeric variable.
Especially, a numeric exposure would be identified as a binary variable
when it has only two values: 0 and 1. However, if the only two values are not 0 and 1,
then users should specify it as a factor variable in advance so that function \code{\link{potentialoutcome_facX}}
would be called automatically instead. The function still works well if the exposure is a multi-level discrete variable.
}
