% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_transformation.R
\name{compute_bart_posterior_interval}
\alias{compute_bart_posterior_interval}
\title{Compute posterior credible intervals for specified terms from a fitted BART model.}
\usage{
compute_bart_posterior_interval(
  model_object,
  terms,
  level = 0.95,
  scale = "linear",
  X = NULL,
  leaf_basis = NULL,
  rfx_group_ids = NULL,
  rfx_basis = NULL
)
}
\arguments{
\item{model_object}{A fitted BART or BCF model object of class \code{bartmodel}.}

\item{terms}{A character string specifying the model term(s) for which to compute intervals. Options for BART models are \code{"mean_forest"}, \code{"variance_forest"}, \code{"rfx"}, or \code{"y_hat"}.}

\item{level}{A numeric value between 0 and 1 specifying the credible interval level (default is 0.95 for a 95\% credible interval).}

\item{scale}{(Optional) Scale of mean function predictions. Options are "linear", which returns predictions on the original scale of the mean forest / RFX terms, and "probability", which transforms predictions into a probability of observing \code{y == 1}. "probability" is only valid for models fit with a probit outcome model. Default: "linear".}

\item{X}{A matrix or data frame of covariates at which to compute the intervals. Required if the requested term depends on covariates (e.g., mean forest, variance forest, or overall predictions).}

\item{leaf_basis}{An optional matrix of basis function evaluations for mean forest models with regression defined in the leaves. Required for "leaf regression" models.}

\item{rfx_group_ids}{An optional vector of group IDs for random effects. Required if the requested term includes random effects.}

\item{rfx_basis}{An optional matrix of basis function evaluations for random effects. Required if the requested term includes random effects.}
}
\value{
A list containing the lower and upper bounds of the credible interval for the specified term. If multiple terms are requested, a named list with intervals for each term is returned.
}
\description{
Compute posterior credible intervals for specified terms from a fitted BART model. Supports intervals for mean functions, variance functions, random effects, and overall outcome predictions.
}
\examples{
n <- 100
p <- 5
X <- matrix(rnorm(n * p), nrow = n, ncol = p)
y <- 2 * X[,1] + rnorm(n)
bart_model <- bart(y_train = y, X_train = X)
intervals <- compute_bart_posterior_interval(
 model_object = bart_model,
 terms = c("mean_forest", "y_hat"),
 X = X,
 level = 0.90
)
}
