% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surprisal_analysis.R
\name{GO_analysis_surprisal_analysis}
\alias{GO_analysis_surprisal_analysis}
\title{Perform Gene ontology analysis on a pattern of interest}
\usage{
GO_analysis_surprisal_analysis(
  transcript_weights,
  percentile_GO,
  lambda_no,
  key_type = "SYMBOL",
  flip = FALSE,
  species.db.str = "org.Hs.eg.db",
  ont = "BP",
  pAdjustMethod = "BH",
  top_GO_terms = 15
)
}
\arguments{
\item{transcript_weights}{a dataframe containing the weight of transcripts in
each pattern}

\item{percentile_GO}{the percentile of transcript to be used for GO analysis,
for example 95 will run GO on transcripts in the 95th percentile and above}

\item{lambda_no}{the lambda pattern the user is interested in analyzing}

\item{key_type}{type of transcripts which can be either SYMBOL, ENTREZID,
ENSEMBL, or PROBEID}

\item{flip}{a boolean variable which can either be true or false, if it is
set to true, the lambda values will be multiplied by -1}

\item{species.db.str}{the type of species used for GO analysis, by default set to
Homo sapiens, can be either 'org.Hs.eg.db' or 'org.Mm.eg.db'}

\item{ont}{the ontology term for GO enrichment analysis. Can be either "BP", "MF" or "CC".
They stand for "Biological Process", "Molecular Function" or "Cellular Component". Set to "BP" by default}

\item{pAdjustMethod}{multiple testing correction method. Could be one of "BH", "bonferroni",
"holm", "hochberg", "hommel", "BY", or "none". The default setting is "BH"}

\item{top_GO_terms}{number of GO terms returns, by default set to 15}
}
\value{
dataframe, the important GO terms related to a lambda gene pattern
}
\description{
Perform Gene ontology analysis on a pattern of interest
}
\examples{

csv.path <- system.file(
  "extdata", "helper_T_cell_0_test.csv",
  package = "SurprisalAnalysis"
)

expr.df <- utils::read.csv(csv.path, check.names = FALSE)
expr.df[1:700,]->expr.df
sa.res <- surprisal_analysis(expr.df, zero.handling = "log1p")
alph.all <- sa.res[[2]]

#In the example below, replace "none" with either 'org.Hs.eg.db' or 'org.Mm.eg.db'.
\donttest{

go_top <- GO_analysis_surprisal_analysis(
    transcript_weights = alph.all,
    percentile_GO      = 99,
    lambda_no          = "lambda_1",
    key_type           = "SYMBOL",
    flip               = FALSE,
    species.db.str     = "none",
    ont                = "BP",
    pAdjustMethod      = "BH",
    top_GO_terms       = 15
    )
}
}
