% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supercell_plot.R
\name{supercell_DimPlot}
\alias{supercell_DimPlot}
\title{Plot metacell 2D plot (PCA, UMAP, tSNE etc)}
\usage{
supercell_DimPlot(
  SC,
  groups = NULL,
  dim.name = "PCA",
  dim.1 = 1,
  dim.2 = 2,
  color.use = NULL,
  asp = 1,
  alpha = 0.7,
  title = NULL,
  do.sqtr.rescale = FALSE
)
}
\arguments{
\item{SC}{SuperCell computed metacell object (the output of \link{SCimplify})}

\item{groups}{an assigment of metacells to any group (for ploting in different colors)}

\item{dim.name}{name of the dimensionality reduction to plot (must be a field in \code{SC})}

\item{dim.1}{dimension to plot on X-axis}

\item{dim.2}{dimension to plot on Y-axis}

\item{color.use}{colros to use for groups, if \code{NULL}, an automatic palette of colors will be applied}

\item{asp}{aspect ratio}

\item{alpha}{a rotation of the layout (either provided or computed)}

\item{title}{a title of a plot}

\item{do.sqtr.rescale}{whether to sqrt-scale node size (to balance plot if some metacells are large and covers smaller metacells)}
}
\value{
\link[ggplot2]{ggplot}
}
\description{
Plots 2d representation of metacells
}
