% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_seeds.R
\name{get_seeds}
\alias{get_seeds}
\title{Generate a reproducible vector of random seeds}
\usage{
get_seeds(masterseed = NULL, nseed = 1000)
}
\arguments{
\item{masterseed}{An integer ranging from \code{1} to \code{.Machine$integer.max} that
sets an overall seed for the simulation to ensure reproducibility of the
results. Defaults to no seed.}

\item{nseed}{A positive integer that specifies the number of subjects to
simulate. Defaults to 1000.}
}
\value{
A vector of numeric integers of length nseed
}
\description{
Use the user-specified \code{masterseed} to generate a vector of randomly sampled
seeds that is reproducible by calling the same \code{masterseed} at a future time.
}
\examples{
get_seeds(masterseed = 513, nseed = 10)
}
