% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{CreateMotifObject}
\alias{CreateMotifObject}
\title{Create motif object}
\usage{
CreateMotifObject(
  data = NULL,
  pwm = NULL,
  motif.names = NULL,
  positions = NULL,
  meta.data = NULL
)
}
\arguments{
\item{data}{A motif x region matrix}

\item{pwm}{A named list of position weight matrices or position frequency
matrices matching the motif names in \code{data}.
Can be of class PFMatrixList.}

\item{motif.names}{A named list of motif names. List element names
must match the names given in \code{pwm}. If NULL, use the names from the
list of position weight or position frequency matrices. This can be used to
set a alternative common name for the motif. If a PFMatrixList is passed to
\code{pwm}, it will pull the motif name from the PFMatrixList.}

\item{positions}{A \code{\link[GenomicRanges]{GRangesList}} object containing
exact positions of each motif.}

\item{meta.data}{A data.frame containing metadata}
}
\value{
Returns a \code{\link{Motif}} object
}
\description{
Create a \code{\link{Motif-class}} object.
}
\examples{
motif.matrix <- matrix(
  data = sample(c(0,1),
    size = 100,
    replace = TRUE),
  ncol = 5
)
rownames(motif.matrix) <- 1:nrow(motif.matrix)
motif <- CreateMotifObject(data = motif.matrix)
}
\concept{motifs}
