% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.PropagateList}
\alias{.PropagateList}
\title{Propagate a List}
\usage{
.PropagateList(x, names, default = NA)
}
\arguments{
\item{x}{A list or character vector}

\item{names}{A vector of names to keep from \code{x}}

\item{default}{A default value for unassigned values of \code{x}}
}
\value{
A named list where the names are present in both \code{x} and
\code{names} and the values are either the values from \code{x} or
\code{default}
}
\description{
Propagate a List
}
\examples{
.PropagateList("counts", c("RNA", "ADT", "SCT"))
.PropagateList(c("counts", "data"), c("RNA", "ADT", "SCT"))
.PropagateList("ADT", c("RNA", "ADT", "SCT"))
.PropagateList(c("RNA", "SCT"), c("RNA", "ADT", "SCT"))
.PropagateList(c("RNA", ADT = "counts"), c("RNA", "ADT", "SCT"))
.PropagateList(list(SCT = c("counts", "data"), ADT = "counts"), c("RNA", "ADT", "SCT"))
.PropagateList(list(SCT = c("counts", "data"), "ADT"), c("RNA", "ADT", "SCT"))

}
\concept{utils}
\keyword{internal}
