% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process-file.R
\name{process_file}
\alias{process_file}
\title{Process a File to Generate Normalised Data and Reports}
\usage{
process_file(
  plate_filepath,
  layout_filepath,
  output_dir = "normalised_data",
  format = "xPONENT",
  generate_report = FALSE,
  process_plate = TRUE,
  normalisation_types = c("MFI", "RAU", "nMFI"),
  blank_adjustment = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{plate_filepath}{(\code{character(1)}) Path to the Luminex plate file.}

\item{layout_filepath}{(\code{character(1)}) Path to the corresponding layout file.}

\item{output_dir}{(\code{character(1)}, default = \code{'normalised_data'})
\itemize{
\item Directory where the output files will be saved.
\item If it does not exist, it will be created.
}}

\item{format}{(\code{character(1)}, default = \code{'xPONENT'})
\itemize{
\item Format of the Luminex data.
\item Available options: \code{'xPONENT'}, \code{'INTELLIFLEX'}, \code{'BIOPLEX'}.
}}

\item{generate_report}{(\code{logical(1)}, default = \code{FALSE})
\itemize{
\item If \code{TRUE}, generates a quality control report using \code{\link[=generate_plate_report]{generate_plate_report()}}.
}}

\item{process_plate}{(\code{logical(1)}, default = \code{TRUE})
\itemize{
\item If \code{TRUE}, processes the plate data using \code{\link[=process_plate]{process_plate()}}.
\item If \code{FALSE}, only reads the plate file and returns the plate object without processing.
}}

\item{normalisation_types}{(\code{character()}, default = \code{c("MFI", "RAU", "nMFI")})
\itemize{
\item List of normalisation types to apply.
\item Supported values: \code{c("MFI", "RAU", "nMFI")}.
}}

\item{blank_adjustment}{(\code{logical(1)}, default = \code{FALSE})
\itemize{
\item If \code{TRUE}, performs blank adjustment before processing.
}}

\item{verbose}{(\code{logical(1)}, default = \code{TRUE})
\itemize{
\item If \code{TRUE}, prints additional information during execution.
}}

\item{...}{Additional arguments passed to \code{\link[=read_luminex_data]{read_luminex_data()}}, \code{\link[=generate_plate_report]{generate_plate_report()}} and \code{\link[=process_plate]{process_plate()}}.}
}
\value{
A \link{Plate} object containing the processed data.
}
\description{
This function reads a Luminex plate file by calling \code{\link[=read_luminex_data]{read_luminex_data()}} and then processes it by calling \code{\link[=process_plate]{process_plate()}}. It optionally generates also a quality control report using \code{\link[=generate_plate_report]{generate_plate_report()}}.
It reads the specified plate file, processes the plate object using all specified normalisation types (including raw MFI values), and saves the results.
If \code{generate_report = TRUE}, a quality control report is also generated.
}
\section{Workflow}{

\enumerate{
\item Read the plate file and layout file.
\item Process the plate data using the specified normalisation types (\code{MFI}, \code{RAU}, \code{nMFI}).
\item Save the processed data to CSV files in the specified \code{output_dir}. The files are named as \verb{\{plate_name\}_\{normalisation_type\}.csv}.
\item Optionally, generate a quality control report. The report is saved as an HTML file in the \code{output_dir}, under the name \verb{\{plate_name\}_report.html}.
}
}

\examples{
# Example 1: Process a plate file with default settings (all normalisation types)
plate_file <- system.file("extdata", "CovidOISExPONTENT_CO_reduced.csv", package = "SerolyzeR")
layout_file <- system.file("extdata", "CovidOISExPONTENT_CO_layout.xlsx", package = "SerolyzeR")
example_dir <- tempdir(check = TRUE)
process_file(plate_file, layout_file, output_dir = example_dir)

# Example 2: Process the plate for only RAU normalisation
process_file(plate_file, layout_file, output_dir = example_dir, normalisation_types = c("RAU"))

# Example 3: Process the plate and generate a quality control report
process_file(plate_file, layout_file, output_dir = example_dir, generate_report = TRUE)

}
