% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-plate.R
\name{plot_counts}
\alias{plot_counts}
\title{Plot counts in a 96-well plate}
\usage{
plot_counts(
  plate,
  analyte_name,
  plot_counts = TRUE,
  plot_legend = FALSE,
  lower_threshold = 50,
  higher_threshold = 70
)
}
\arguments{
\item{plate}{The plate object with the counts data}

\item{analyte_name}{The name of the analyte}

\item{plot_counts}{Logical indicating if the counts should be plotted}

\item{plot_legend}{Logical indicating if the legend should be plotted}

\item{lower_threshold}{The lower threshold for the counts, it separates green and yellow colours}

\item{higher_threshold}{The higher threshold for the counts, it separates yellow and red colours}
}
\value{
A ggplot object
}
\description{
This function plots counts in a 96-well plate using a colour to represent the count ranges.
There is a possibility of plotting exact counts in each well. \cr \cr
If the plot window is resized, it's best to re-run the function to adjust the scaling.
Sometimes, when a legend is plotted, the whole layout may be shifted. It's best to stretch the window, and everything will be adjusted automatically.
}
\examples{
plate_filepath <- system.file("extdata", "CovidOISExPONTENT_CO.csv",
  package = "SerolyzeR", mustWork = TRUE
)
layout_filepath <- system.file("extdata", "CovidOISExPONTENT_CO_layout.xlsx",
  package = "SerolyzeR", mustWork = TRUE
)
plate <- read_luminex_data(plate_filepath, layout_filepath)
plot_counts(
  plate = plate, analyte_name = "OC43_NP_NA",
  plot_counts = TRUE, plot_legend = FALSE
)

}
