% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sb_beta.R
\name{sb_apply_selector_manual}
\alias{sb_apply_selector_manual}
\title{Apply a selector to a collection of resampled designs}
\usage{
sb_apply_selector_manual(
  X_norm,
  resamples,
  Y,
  selector,
  ...,
  keep_template = TRUE
)
}
\arguments{
\item{X_norm}{Normalised design matrix.}

\item{resamples}{List of matrices returned by \code{\link[=sb_resample_groups]{sb_resample_groups()}}.}

\item{Y}{Numeric response.}

\item{selector}{Variable-selection routine; function or character string. If
it is a function, the selector name should be added as the fun.name attribute.}

\item{...}{Extra arguments passed to the selector.}

\item{keep_template}{Logical; when \code{TRUE} (default) the first column stores the
coefficients fitted on \code{X_norm} before any resampling. This avoids
recomputing the selector on the original data and keeps the baseline fit
available for diagnostics.}
}
\value{
A numeric matrix of coefficients with one column per resample.
}
\description{
Apply a selector to a collection of resampled designs
}
