% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{confint.SSN2}
\alias{confint.SSN2}
\alias{confint.ssn_lm}
\alias{confint.ssn_glm}
\title{Confidence intervals for fitted model parameters}
\usage{
\method{confint}{ssn_lm}(object, parm, level = 0.95, ...)

\method{confint}{ssn_glm}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{parm}{A specification of which parameters are to be given confidence
intervals (a character vector of names). If missing, all parameters are considered.}

\item{level}{The confidence level required. The default is \code{0.95}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
Gaussian-based confidence intervals (two-sided and equal-tailed) for the
fixed effect coefficients based on the confidence level specified by \code{level}.
For \code{ssn_glm()} objects, confidence intervals are on the link scale.
}
\description{
Computes confidence intervals for one or more parameters in a fitted
model object.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
confint(ssn_mod)
confint(ssn_mod, level = 0.9)
}
