% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_calcSRratio.R
\name{calcSRratio}
\alias{calcSRratio}
\title{Calculate the Stress Response ratio (SRratio)}
\usage{
calcSRratio(.data, var1, var2, pair, is.log2 = NA)
}
\arguments{
\item{.data}{A data frame containing expression values for a series of arrays, with rows corresponding to genes and columns to samples.}

\item{var1}{A character vector containing column names of control samples.}

\item{var2}{A character vector containing column names of treatment samples.}

\item{pair}{A data frame with control samples and treatment samples.}

\item{is.log2}{A logical value (TRUE, FALSE) or NA indicating whether the data in .data is log2-transformed:
\itemize{
\item If TRUE, the SR ratio is calculated as the difference between the target and reference variables.
\item If FALSE, the SR ratio is calculated as the log2-transformed ratio: log2((target + 1) / (reference + 1)).
\item If NA (default), the user will be prompted interactively to confirm whether the data is log-transformed.
}}
}
\value{
A data frame containing:
\itemize{
\item Character columns from the original .data.
\item Mean SRratio values for each unique target variable.
}
}
\description{
This function computes the Stress Response ratio (SR ratio) for paired variables in a dataset.
The function supports both log2-transformed and non-log2-transformed data and calculates the mean SRratio for grouped variables.
}
\examples{
var1 <- "control_sample"
var2 <- "treated_sample"
grp <- "Series"

ebg <- expand_by_group(MetadataABA, grp, var1, var2)

SRratio <- calcSRratio(TranscriptomeABA, var1, var2, ebg, is.log2 = TRUE)

}
