% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRSplineMedBoot.R
\name{SRSplineMedBoot}
\alias{SRSplineMedBoot}
\title{Calculate the CDE, NDE and NIE of bootstrapped data.}
\usage{
SRSplineMedBoot(
  data,
  nBasis,
  exposure,
  mediator,
  mediatorSim,
  outcomeSim,
  confounderVec,
  shapeExp,
  shapeNonExp,
  mValue
)
}
\arguments{
\item{data}{A data frame.}

\item{nBasis}{The number of bases.}

\item{exposure}{The name of the exposure (must be a binary variable).}

\item{mediator}{The name of the mediator (must be a continuous variable).}

\item{mediatorSim}{The name of the simulated mediator (must be a continuous variable).}

\item{outcomeSim}{The name of the simulated outcome (must be a continuous variable).}

\item{confounderVec}{The name vector of the confounders.}

\item{shapeExp}{The shape of mediator in exposure group ("increasing", "decreasing", "convex", or "concave").}

\item{shapeNonExp}{The shape of mediator in non-exposure group ("increasing", "decreasing", "convex", or "concave").}

\item{mValue}{The controlled mediator value for CDE estimation.}
}
\value{
A list of CDE, NDE and NIE.
}
\description{
Calculate the CDE, NDE and NIE of bootstrapped data.
}
\keyword{internal}
