% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPareto.R
\name{simPareto}
\alias{simPareto}
\title{Simulate Pareto-type Dynamic GLM}
\usage{
simPareto(N = 1000L, q = 4L)
}
\arguments{
\item{N}{Integer > 1, series length.}

\item{q}{Integer >= 1, number of predictors (used only for interface compatibility;
no covariates are currently used in the generator).}
}
\value{
List with components:
\item{Y}{Numeric vector of length N, Pareto-type observations (y >= 1).}
\item{lambda}{Numeric vector of length N, dynamic inverse-scale process.}
\item{G}{AR(1) persistence coefficient (|G| < 1).}
\item{sig2}{Innovation variance sigma^2.}
}
\description{
Generates a dynamic time-series where
y_t = 1 + Gamma(shape = 1, scale = 1/lambda_t),
and the inverse-scale lambda_t follows a stationary AR(1) process.
}
\examples{
set.seed(2)
dat <- simPareto(N = 500, q = 3)
plot(dat$lambda, type = "l")

}
