% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_paradox.R
\name{read_paradox}
\alias{read_paradox}
\title{Read a Paradox Database File into a Tibble}
\usage{
read_paradox(path, encoding = NULL)
}
\arguments{
\item{path}{A character string specifying the path to the Paradox (.db) file.}

\item{encoding}{An optional character string specifying the input encoding of
the data (e.g., "cp866", "cp1252"). If \code{NULL} (the default), the encoding
is determined from the file header.}
}
\value{
A \code{tibble} containing the data from the Paradox file.
}
\description{
A high-level, user-friendly wrapper function that reads an entire Paradox
database file (.db) and returns its contents as a tibble.
}
\details{
This function simplifies the process of reading Paradox files by handling the
complete workflow in a single call:
\enumerate{
\item It validates the input path and encoding.
\item It safely opens a handle to the file using \code{pxlib_open_file()}.
\item It ensures the file handle is always closed using \code{on.exit()}, even if
errors occur during data reading.
\item It reads the data using \code{pxlib_get_data()}.
\item It returns a clean \code{tibble}.
}

If the specified file does not exist, the function will issue a warning and
return an empty tibble.
}
\examples{
# Read the demo database in one step
db_path <- system.file("extdata", "biolife.db", package = "Rparadox")
if (file.exists(db_path)) {
  biolife_data <- read_paradox(db_path)
  print(biolife_data)
}
}
