% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDepthLayerInfo.R
\name{getDepthLayerInfo}
\alias{getDepthLayerInfo}
\title{Extract depth layer information from root scans}
\usage{
getDepthLayerInfo(
  root_df = NULL,
  depth_levels_cm = rbind(c(0, -10), c(-10, -20), c(-20, -30), c(-30, -40)),
  overwrite = FALSE,
  save_csvs = TRUE,
  save_pngs_col = "grey"
)
}
\arguments{
\item{root_df}{Data frame (default = NULL) specifying the structure
of the root scan data. It can be created using the function
\code{getOverviewInput()}. The data frame must contain several mandatory
features and can comprise other optional features, some of which have a
functional importance and others have no influence but will be included
in the output data frame). Any feature not listed here is treated as
completely optional: \cr
\itemize{
\item --------------- Mandatory --------------- \cr
\item \code{dir_name_full}: Full path to directory.  \cr
\item \code{dir_name}: name of directory.  \cr
\item \code{depth_window}: depth-level/window. 1 indicates the scan highest scan,
2 the next scan somewhat lower in ground, and so forth. \cr
\item -------- Optional, but functionally important -------- \cr
\item \code{top_side}: One of "left","top","right","bottom". Indicates where
the upper side of the image is. If not specified, "left" is used. \cr
\item \code{tube_angle}: Installation angle of the tube (angle between surface
plane and tube above ground, in degrees, >0 and <90). If not specified, an
angle of 45 degrees is assumed. \cr
\item \code{depth_highpoint_cm}: Depth in cm of the highest point in the
image, e.g., 0 indicating that the top border of the scan scratched the
surface of the soil or -5 indicating that it lies 5 cm deep in the soil.
This is mostly important for all scans of \code{depth_window} 1 (or the
lowest number if the depth windows are not 1,2,3,4,...) if all
images are stitched together. If not specified, it is assumed that the
top border of scan of \code{depth_window} 1 lies at depth 0. \cr
\item \code{pos_highpoint_px}: Either one of "center" or "edge",
indicating that scanning starts at the bottom or top facing side of the
minirhizotron, respectively, or it can also be an integer value (>=1 and
<=width of the \code{top_side} of the image) specifying where (left<->right)
in the top row of the image the highest point of the image lies, indicating
the column where the minimum points of the depth-level lines lie. \cr
If not specified, "center" is assumed as scanning often starts at the
bottom facing side of the minirzhizotron. \cr
See also \code{gap_cm} if there is a non-zero gap. \cr
\item \code{ppcm} Pixels per centimeter, the resolution of the image.
If not specified (NULL or NA), \code{ppi} is used.
Common resolutions are 300 ppi (or dpi, for print jobs) which is 118 px/cm,
150 ppi which is 59 px/cm, and 72 ppi (for screens) which is 28 px/cm.\cr
\item \code{ppi} Pixels per inch, the resolution of the image.
If \code{ppcm} and \code{ppi} arenot specified, 300 ppi is used.
Common resolutions are 300 ppi (or dpi, for print jobs) which is 118 px/cm,
150 ppi which is 59 px/cm, and 72 ppi (for screens) which is 28 px/cm.\cr
\item \code{overlap_px} Overlap in pixels of the current image and the image of
the previous depth window for the stitching process, i.e., this is not
important for the image of the first depth window.
While stitching it will be checked if there is a better overlap in a small
area around the specified value (see \code{max_shift_px}).
If not specified it is set to 1's.\cr
\item \code{max_shift_px} Radius around \code{overlap_px} that is checked for
better overlap matching. If not specified it is set to 0 (no alternatives
are checked).\cr
\item \code{gap_cm} Numeric value that specifies if there is a gap
(in cm) between the two "matching" sides of the image, i.e., there is no full
rotation of the scanner. If \code{pos_highpoint_px} is specified as "center"
or "edge" (in characters), then it is assumed that the middle of the gap is
right at the top or bottom facing side of the tube, i.e. it is not possible
to start and end at the exact top/bottom. If \code{pos_highpoint_px} is
specified as a numeric value, then it is considered as exact and the gap
does not move it.\cr
If not specified and if \code{gap_deg} is NA as well, no gap (0) is
assumed. \cr
\item \code{gap_deg} Numeric value that specifies if there is a gap
(in degrees, i.e. from 0 to 360) between the two "matching" sides of the
image, i.e., there is no full rotation of the scanner.
Works similar to \code{gap_cm}.
Only used if \code{gap_cm} is not specified.\cr
\item \code{project}: Project name. Needed to identify scans that should be
stitched. \cr
\item \code{tube}: ID of the minirhizotron. Needed to identify scans that should
be stitched.  \cr
\item \code{date}: Date of the scanning. Needed to identify scans that should be
stitched. \cr
\item \code{session}: ID of the scan session. Needed to identify scans that
should be stitched.  \cr
\item ------------ Completely optional ------------ \cr
\item \code{ID}: ID of the scan (6 digits) or timecode. \cr
\item \code{operator}: ID of the person that scanned the root. \cr
\item \code{file_extension}: File format: png, tiff, jpg, or jpeg
(upper or lowercase).
}}

\item{depth_levels_cm}{Numeric matrix with two columns and at least
one row. Each row specifies a depth interval (in cm) that is of
interest. For each interval a masking layer is generated. The first value
of each row has to be larger than the second (decending).\cr
By default: Depth layers 0-(-10)cm, -10-(-20)cm, -20-(-30)cm, and
-30-(-40)cm.}

\item{overwrite}{If FALSE (default), root scan directories are skipped that
have already been processed by a particular procedure, i.e., there already
are stitched images before beginning the stitching procedure, there already
are images with depth layers drawn in before saving thme or there already is
a statistics_withDepthLayers.csv file when it comes to evaluating the image.
If TRUE, all procedures are applied to the scan and corresponding files are
overwritten.}

\item{save_csvs}{Specifies if csv files for the individual scans should be
saved in the scan's directory (default TRUE).}

\item{save_pngs_col}{If not NULL, the root scans with depth layers drawn in
are saved in the scan's directory. Specifies the color of the FALSE-regions
of the mask (default "grey"). Can be a vector of the same length as
the number of depth intervals to allow each layer to be drawn in with a
different color. \cr
Can be of any of the three kinds of R color specifications, i.e., either a
color name (as listed by colors()), a hexadecimal string (see Details), or a
positive integer (indicates using palette()).}
}
\value{
\code{getDepthLayerInfo} A data frame containing the depth layer
information of all individual scans.
}
\description{
\code{getDepthLayerInfo} - Specify a set of root scan directories in the
form of a data frame (e.g., by using \code{getOverviewInput()}). Then, the
function will do the following: \cr
\itemize{
\item If there are several depth windows of the same root scan (project, tube,
date and session have to be identical), then these will be stitched and
saved in directory of the scan of depth window 1. \cr
\item Create depth layer masks corresponding to the specified
\code{depth_levels_cm}. \cr
\item Computes a range of values from the scans (per depth layer: "pixels_root",
"pixels_bg", "skel_pixels_total", "skel_pixels_low3", "skel_pixels_3-7",
"skel_pixels_larg7","kimura_length6") and if (\code{save_csvs} = TRUE) saves
them as a csv file in the directory of the scan of depth window 1. \cr
\item Returns a data frame containing values listed above of all scans.
}
}
\examples{
getDepthLayerInfo()
}
