% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/systematic.R
\name{fuzzy_coco_systematic_fit}
\alias{fuzzy_coco_systematic_fit}
\title{systematic search}
\usage{
fuzzy_coco_systematic_fit(x, y, params, fitter)
}
\arguments{
\item{x}{the input variables data (usually to fit) as a dataframe}

\item{y}{the output variables data (usually to fit)  as a dataframe}

\item{params}{fuzzy coco parameters, as a recursive named list, cf \code{\link[=params]{params()}}}

\item{fitter}{a function metrics --> fitness value providing the objective/fitness function to optimize
TODO: describe the metrics}
}
\value{
a list of the best results (all ties). Each result is also a named list(metric=,fs=) holding the
corresponding metric value and the fuzzy system.
}
\description{
This is a R implementation of a systematic search, where the fuzzy set positions are determined
by the distribution of the data (cf \code{\link[=compute_optimal_quantile_fuzzy_set_positions]{compute_optimal_quantile_fuzzy_set_positions()}} and the rules
are systematically explored
}
\details{
N.B: this is experimental, only possible for a small number of variables.
Not all parameters are used, obviously, and currently fitness_params$output_vars_defuzz_thresholds
has to be set explicitly.
}
\examples{
fitter <- function(metrics) 2^-metrics$rms
params <- example_mtcars()$params
params$fitness_params$output_vars_defuzz_thresholds <- 0
params$global_params$nb_rules <- 1
params$global_params$nb_max_var_per_rule <- 2
params$output_vars_params$nb_sets <- 2

x <- mtcars[c("mpg", "hp", "wt")]
y <- mtcars["qsec"]
fit <- fuzzy_coco_systematic_fit(x, y, params, fitter)
}
