% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preFitModel.R
\name{preFitModel}
\alias{preFitModel}
\title{Fits a linear mixed model (without fixed SNP effects) and computes the fitted variance-covariance matrix for later use in the rGLS function.}
\usage{
preFitModel(
  fixed = y ~ 1,
  random = ~1 | id,
  id.name = "id",
  genabel.data,
  phenotype.data,
  corStruc = NULL,
  GRM = NULL,
  Neighbor.Matrix = NULL,
  verbose = TRUE
)
}
\arguments{
\item{fixed}{A formula including the response and fixed effects}

\item{random}{A formula for the random effects}

\item{id.name}{The column name of the IDs in phen.data}

\item{genabel.data}{An GenABEL-like object including marker information. This object has one observation per individual.}

\item{phenotype.data}{A data frame including the repeated observations and IDs.}

\item{corStruc}{A list specifying the correlation structure for each random effect. The options are: \code{"Ind"} for iid random effects, \code{"GRM"} for a correlation structure given by a genetic relationship matrix, or \code{"CAR"} for a spatial correlation structure given by a Conditional Autoregressive model specified by a neighborhood matrix.}

\item{GRM}{A genetic relationship matrix. If not specified whilst the \code{"GRM"} option is given for \code{corStruc} then the GRM is computed internally within the function.}

\item{Neighbor.Matrix}{A neighborhood matrix having non-zero value for an element (i,j) where the observations i and j come from neighboring locations. The diagonal elements should be zero.}

\item{verbose}{If TRUE the progress of the computations is printed.}
}
\value{
Returns a list including the fitted hglm object \code{fitted.hglm}, the variance-covariance matrix \code{V} and the ratios between estimated variance components for the random effects divided by the residual variance, \code{ratio}.
}
\description{
Uses a GenABEL-like object and phenotype data as input. The model is fitted using the \code{hglm} function in the hglm package.
}
\examples{
 ####### FIRST EXAMPLE USING GRM #############
 set.seed(1234)
 Gen.Data <- simulate_gendata(n=100, p=200)
 Phen.Data <- simulate_PhenData(y ~ 1, genabel.data=Gen.Data,
                               n.obs=rep(4, nids(Gen.Data)), SNP.eff=2, SNP.nr=100, VC=c(1,1,1))
 GWAS1 <- rGLS(y ~ 1, genabel.data = Gen.Data, phenotype.data = Phen.Data)
 plot(GWAS1, main="")
 summary(GWAS1)
 #Summary for variance component estimation without SNP effects
 summary(GWAS1@call$hglm)
 #The same results can be computed using the preFitModel as follows
 fixed = y ~ 1
 Mod1 <- preFitModel(fixed, random=~1|id, genabel.data = Gen.Data,
                     phenotype.data = Phen.Data, corStruc=list( id=list("GRM","Ind") ))
 GWAS1b <- rGLS(fixed, genabel.data = Gen.Data,
                phenotype.data = Phen.Data, V = Mod1$V)
 plot(GWAS1b, main="Results using the preFitModel function")

}
\author{
Lars Ronnegard
}
