% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_to_rga.R
\name{weibull_to_rga}
\alias{weibull_to_rga}
\title{Weibull to RGA}
\usage{
weibull_to_rga(
  failures,
  suspensions = NULL,
  interval_starts = NULL,
  interval_ends = NULL
)
}
\arguments{
\item{failures}{A numeric vector of exact failure times. Each failure time
indicates when an item failed during the observation period.}

\item{suspensions}{A numeric vector of suspension (right-censored) times. A suspension
indicates that the item was removed from observation at that time without failure.
This parameter is optional and can be NULL if there are no suspensions.}

\item{interval_starts}{A numeric vector of interval start times (lower bound of censoring).
This parameter is optional and can be NULL if there are no interval-censored data.
If provided, it must be the same length as \code{interval_ends}.}

\item{interval_ends}{A numeric vector of interval end times (upper bound of censoring).
This parameter is optional and can be NULL if there are no interval-censored data.
If provided, it must be the same length as \code{interval_starts}.}
}
\value{
The data frame contains two columns:
\item{CumulativeTime}{Cumulative time at each failure event.}
\item{Failures}{Number of failures at each cumulative time point.}
The function approximates interval-censored failures by placing them at the midpoint
of the interval.
}
\description{
Converts Weibull data (failure, suspension, and interval-censored times)
into a format suitable for reliability growth analysis (RGA). The function
handles exact failure times, right-censored suspensions, and interval-censored data.
It approximates interval-censored failures by placing them at the midpoint of the interval.
The output is a data frame with cumulative time and failure counts. This format
can be used with RGA models such as Crow-AMSAA.
}
\examples{
failures <- c(100, 200, 200, 400)
suspensions <- c(250, 350, 450)
interval_starts <- c(150, 300)
interval_ends <- c(180, 320)
result <- weibull_to_rga(failures, suspensions, interval_starts, interval_ends)
print(result)
}
\concept{data preparation}
