% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QvalIndex.R
\name{zTNR}
\alias{zTNR}
\title{Calculate True-Negative Rate (TNR)}
\usage{
zTNR(Q.true, Q.orig, Q.sug)
}
\arguments{
\item{Q.true}{The true Q-matrix.}

\item{Q.orig}{The Q-matrix need to be validated.}

\item{Q.sug}{The Q-matrix that has been validated.}
}
\value{
A numeric (TNR index).
}
\description{
Calculate True-Negative Rate (TNR)
}
\details{
TNR is defined as the proportion of correct elements which are correctly retained:
\deqn{
 TNR = \frac{\sum_{i=1}^{I}\sum_{k=1}^{K}I(q_{ik}^{t} = q_{ik}^{s} | q_{ik}^{t} \neq q_{ik}^{o})}
 {\sum_{i=1}^{I}\sum_{k=1}^{K}I(q_{ik}^{t} \neq q_{ik}^{o})}
}
where \eqn{q_{ik}^{t}} denotes the \eqn{k}th attribute of item \eqn{i} in the true Q-matrix (\code{Q.true}),
\eqn{q_{ik}^{o}} denotes \eqn{k}th attribute of item \eqn{i} in the original Q-matrix(\code{Q.orig}),
\eqn{q_{ik}^{s}} denotes \eqn{k}th attribute of item \eqn{i} in the suggested Q-matrix(\code{Q.sug}),
and \eqn{I(\cdot)} is the indicator function.
}
\examples{
library(Qval)

set.seed(123)

Q1 <- sim.Q(5, 30)
Q2 <- sim.MQ(Q1, 0.1)
Q3 <- sim.MQ(Q1, 0.05)
TNR <- zTNR(Q1, Q2, Q3)

print(TNR)

}
