% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{apply_butter}
\alias{apply_butter}
\title{Applies a Butterworth filter to each event.}
\usage{
apply_butter(data = data, n = NULL, W = NULL, type = NULL, plane = "z")
}
\arguments{
\item{data}{A data table object.}

\item{n}{A number specifying the filter order (as described in
\link[signal]{butter}).}

\item{W}{The critical frequencies of the filter (as described in
\link[signal]{butter}). W must be a scalar for low-pass or high-pass filters.
W must be a two-element vector c(low, high) specifying the lower and upper
bands for stop-band or band-pass filters. For digital filters, W must be
between 0 and 1 where 1 is the Nyquist frequency.}

\item{type}{The filter type (as described in \link[signal]{butter}), one of
"low" for a low-pass filter, "high" for a high-pass filter, "stop" for a
stop-band (band-reject) filter, or "pass" for a pass-band filter.}

\item{plane}{A character string (as described in \link[signal]{butter}), "z"
for a digital filter or "s" for an analog filter.}
}
\value{
An object of type data table as described in \link[tibble]{tibble}.
}
\description{
\code{apply_butter} applies a Butterworth filter to the pupil
size data.
}
\examples{
# Load example data
data("Pupilex5")

dat <- apply_butter(Pupilex5, n = 1, W = 0.1,
                    type = "low", plane = "z")

# Please see the vignettes for detailed example usage.
vignette("PupilPre_Interpolation_and_Filtering", package="PupilPre")

}
