% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samples.R
\name{pt2_sample_to_audio}
\alias{pt2_sample_to_audio}
\title{Coerce ProTracker sample to audio sample}
\usage{
pt2_sample_to_audio(
  sample,
  note = "C-3",
  finetune = 0,
  options = pt2_render_options(),
  loop = 20L,
  ...
)
}
\arguments{
\item{sample}{A ProTracker sample of class \code{pt2samp}.}

\item{note}{A character representing a note (\code{"C-3"} by default).
It is used to calculate the playback rate for the sample.}

\item{finetune}{An \code{integer} fine tune value (between -8 and 7). Used
to tune the sample's note.}

\item{options}{Options used for calculating play back rate. See
\code{\link[=pt2_render_options]{pt2_render_options()}} for all available options. But note that
not all options affect the play back rate.}

\item{loop}{An \code{integer} value indicating how often the sample
should be looped (if it is looped). It will be ignored when \code{loop} has
a value of zero (or less), or when the sample is not looped
(see \code{\link[=pt2_is_looped]{pt2_is_looped()}}).}

\item{...}{Ignored}
}
\value{
Returns an audio sample of class \code{\link[audio:audioSample]{audio::audioSample()}}.
}
\description{
Coerce a sample from a ProTracker module to an \code{audio} package
sample. Note that this function differs from \code{\link[=pt2_render]{pt2_render()}} as
it will not mimic Commodore Amiga hardware. It will just
pass the pure sample data.
}
\examples{
mod <- pt2_read_mod(pt2_demo())
aud <- pt2_sample_to_audio(mod$samples[[1]])
}
