% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoFAST.R
\name{coembed_plot}
\alias{coembed_plot}
\title{Coembedding dimensional reduction plot}
\usage{
coembed_plot(
  seu,
  reduction,
  gene_txtdata = NULL,
  cell_label = NULL,
  xy_name = reduction,
  dims = c(1, 2),
  cols = NULL,
  shape_cg = c(1, 5),
  pt_size = 1,
  pt_text_size = 5,
  base_size = 16,
  base_family = "serif",
  legend.point.size = 5,
  legend.key.size = 1.5,
  alpha = 0.3
)
}
\arguments{
\item{seu}{a Seurat object with coembedding in the reductions slot wiht component name reduction.}

\item{reduction}{a string, specify the reduction component that denotes coembedding.}

\item{gene_txtdata}{a data.frame object with columns indcluding `gene` and `label`, specify the cell type/spatial domain and signature genes. Default as NULL, all features will be used in comebeddings.}

\item{cell_label}{an optional character in columns of metadata,  specify the group of cells/spots. Default as NULL, use Idents as the group.}

\item{xy_name}{an optional character,  specify the names of x and y-axis, default as the same as reduction.}

\item{dims}{a postive integer vector with length 2, specify the two components for visualization.}

\item{cols}{an optional string vector, specify the colors for cell group in visualization.}

\item{shape_cg}{a positive integers with length 2, specify the shapes of cell/spot and feature in plot.}

\item{pt_size}{an optional integer, specify the point size, default as 1.}

\item{pt_text_size}{an optional integer, specify the point size of text, default as 5.}

\item{base_size}{an optional integer, specify the basic size.}

\item{base_family}{an optional character, specify the font.}

\item{legend.point.size}{an optional integer, specify the point size of legend.}

\item{legend.key.size}{an optional integer, specify the size of legend key.}

\item{alpha}{an optional positive real, range from 0 to 1, specify the transparancy of points.}
}
\value{
return a ggplot object
}
\description{
Graph  output of a dimensional reduction technique on a 2D scatter plot where each point is a cell or feature and it's positioned based on the  coembeddings determined by the reduction technique. By default, cells and their signature features are colored by their identity class (can be changed with the group.by parameter).
}
\details{
None
}
\examples{
data(pbmc3k_subset)
data(top5_signatures)
coembed_plot(pbmc3k_subset, reduction = "UMAPsig",
 gene_txtdata = top5_signatures,  pt_text_size = 3, alpha=0.3)

}
\references{
None
}
\seealso{
\code{\link{coembedding_umap}}
}
