% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_random_effects_structure}
\alias{get_random_effects_structure}
\title{Get the Expected Random-Effects Structure}
\usage{
get_random_effects_structure(formula, design, family = "gaussian")
}
\arguments{
\item{formula}{An lme4-style model formula (e.g. \code{outcome ~ predictor1 * predictor2 + (1 | id)}).}

\item{design}{A \code{PowRPriori_design} object created with \code{define_design()}.}

\item{family}{The model family (\code{"gaussian"}, \code{"binomial"}, \code{"poisson"}).
Determines if \code{sd_resid} should be included in the template.}
}
\value{
Invisibly returns a nested list with placeholders, serving as a
template for the \code{random_effects} argument in \code{power_sim()}.
}
\description{
Analyzes the random effects terms in a model formula and generates a template
for the specified \code{random_effects} parameters. This helps in specifying the required
standard deviations and correlations correctly. By default, this function prints a copy-paste-able code snippet
to the console, where the user only needs to fill in placeholders (\code{...}) for the values.
}
\examples{
design <- define_design(
  id = "subject",
  within = list(time = c("pre", "post"))
)
get_random_effects_structure(y ~ time + (time|subject), design)
}
