% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{define_design}
\alias{define_design}
\title{Define the Experimental Structure of an Experimental Design}
\usage{
define_design(id, between = NULL, within = NULL, nesting_vars = NULL)
}
\arguments{
\item{id}{A string specifying the name of the lowest-level unit of observation
(e.g., \code{"subject"}, \code{"pupil"}, \code{plot_of_land}).}

\item{between}{A list of between-subject factors. Can be a simple list (for
individual assignment) or a nested list (e.g., \code{list(class = list(group = ...))})
for group-level assignment.}

\item{within}{A list of within-subject factors. Each \code{id} will be measured
at every level of these factors.}

\item{nesting_vars}{A list of variables that are only used for grouping in the
random effects structure (e.g., \code{(1|school/class)}).}
}
\value{
A \code{PowRPriori_design} object, which is a list containing the design specifications.
}
\description{
This is the primary setup function for any power simulation. It creates a
special \code{PowRPriori_design} object that contains all the necessary information
about the variables and structure of your study.
}
\details{
Variables can be specified as different types. Nominal scale variables (e.g. group with levels "control" and "treatment")
can be specified as factors (\code{group = factor(c("control", "treatment"))}) or as character vectors (\code{c("control", "treatment")}),
in which case they are automatically converted to factors later on. Continuous variables can  be specified via mean
and standard deviation (\code{test_score = list(mean = 10, sd = 5)}). Additionally, variables can also be defined as numerical vectors
(\code{predictor = 1:4}).

The \code{between} argument is particularly flexible. For simple designs, you can
provide a "flat" list of factors. For complex designs like cluster-randomized
trials, you can provide a hierarchical list to specify the level of
assignment (see examples). For a full tutorial, see the package vignette:
\code{vignette("Workflow-Example", package = "PowRPriori")}
}
\examples{
# Simple 2x2 mixed design
simple_design <- define_design(
  id = "subject",
  between = list(group = c("Control", "Treatment")),
  within = list(time = c("pre", "post"))
)

# A nested (cluster-randomized) design where the intervention
# is assigned at the class level.
nested_design <- define_design(
  id = "pupil",
  between = list(
    class = list(intervention = c("yes", "no"))
  ),
  nesting_vars = list(class = factor(1:10))
)
}
