% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/technical_indicators.R
\name{calc_stochastic_d}
\alias{calc_stochastic_d}
\title{Calculate Stochastic D Indicator}
\usage{
calc_stochastic_d(data, k = 14, d = 3)
}
\arguments{
\item{data}{Price data with Date column and symbol columns}

\item{k}{Lookback period for stochastic K calculation}

\item{d}{Smoothing period for D line}
}
\value{
Data.table with Stochastic D values for each symbol
}
\description{
Calculates the Stochastic D indicator for momentum analysis.
The \%D line is the smoothed version of \%K, commonly used for
momentum signals in range 0-100.
}
\examples{
data("sample_prices_weekly")
data(sample_prices_weekly)
data("sample_prices_weekly")
stoch_d <- calc_stochastic_d(sample_prices_weekly, k = 14, d = 3)
head(stoch_d)
}
