% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_stats.R
\name{calculate_ddct}
\alias{calculate_ddct}
\title{Calculate ddCt Statistics}
\usage{
calculate_ddct(data, ref_gene, control_group)
}
\arguments{
\item{data}{Output from import_plate().}

\item{ref_gene}{Name of the housekeeping gene (e.g., "GAPDH").}

\item{control_group}{Name of the control condition (e.g., "WT").}
}
\value{
A comprehensive dataframe with Fold Changes, Log2FC, P-values, and Error bars.
}
\description{
Performs the complete Delta-Delta Ct method with error propagation.
}
\examples{
# Mock data: 2 biological replicates per group to allow t-test
df <- data.frame(
  Sample = c("S1", "S2", "S3", "S4"),
  Group = c("WT", "WT", "Treated", "Treated"),
  Gene = c(rep("GAPDH", 4), rep("Target", 4)),
  Ct = c(20, 20.1, 20.2, 20.3,   # GAPDH (Consistent)
         25, 24.8, 21, 21.2)     # Target (Down in Treated)
)

calculate_ddct(df, ref_gene = "GAPDH", control_group = "WT")
}
