% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth.R
\name{growth}
\alias{growth}
\title{Growth Indices}
\usage{
growth(data, gr.area, t.interval1, t.interval2)
}
\arguments{
\item{data}{Data frame with input columns:
\itemize{
\item \code{Gen}: Character vector of Genotype IDs.
\item \code{LDW_PI, LDW_PII, LDW_PIII}: Leaf dry weight (LDW) for three distinct phases I-III (PI-PIII).
\item \code{CDW_PI, CDW_PII, CDW_PIII}: Cane/crop dry weight (CDW) for three distinct phases I-III (PI-PIII).
\item \code{LA_PI, LA_PII, LA_PIII)}: Leaf area (LA) for three distinct phases I-III (PI-PIII).
}}

\item{gr.area}{Ground area occupied by the sample (cm^2 or m^2, same unit as that of leaf area) (user must define this input).}

\item{t.interval1}{Time interval (days) between consecutive sampling phases PI and PII (user must define this input).}

\item{t.interval2}{Time interval (days) between consecutive sampling phases PII and PIII (user must define this input).}
}
\value{
A list of result components:
\itemize{
\item \code{Gen}: Character vector of genotype IDs.
\item \code{LAI_PI, LAI_PII, LAI_PIII)}: Leaf Area Index (LAI) for three distinct phases I-III (PI-PIII).
\item \code{NAR_PII, NAR_PIII}: Net Assimilation Rate (NAR) for two consecutive sampling intervals (PI–PII) and (PII–PIII).
\item \code{CGR_PII, CGR_PIII}: Crop Growth Rate (CGR) for two consecutive sampling intervals (PI–PII) and (PII–PIII).
}
}
\description{
This function computes genotype (Gen) wise growth indices-leaf area index (LAI), net assimilation rate (NAR), and crop growth rate (CGR) for time intervals between distinct stages/phases (days). For more details see Williams (1946), and Watson (1958) \url{doi:10.1093/oxfordjournals.aob.a083596}.
}
\examples{
# Creating a sample dataset
df <- data.frame(
Gen = c("V1","V2","V3"),
LA_PI  = c(599.4,544.4,573.2),
LA_PII = c(1533.4,1088.0,1633.1),
LA_PIII= c(1111.2,866.0,1181.0),
LDW_PI = c(83.9,136.1,137.6),
CDW_PI = c(36.1,55.9,57.3),
LDW_PII= c(138.5,193.2,183.0),
CDW_PII= c(76.2,136.4,145.0),
LDW_PIII=c(292.2,386.5,450.1),
CDW_PIII=c(190.4,336.8,323.4)
)
growth(df, gr.area = 250, t.interval1 = 30, t.interval2 = 60)

}
\references{
Williams, R.F. (1946). The physiology of plant growth with special reference to the concept of net assimilation rate. Annals of Botany, 10(37), 41-72.

Watson, D.J. (1958). \url{doi:10.1093/oxfordjournals.aob.a083596}.
}
