% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRP.R
\name{MRP}
\alias{MRP}
\title{Mean Relative Performance (MRP)}
\usage{
MRP(Gen, YN, YS, YMN = NULL, YMS = NULL)
}
\arguments{
\item{Gen}{Character vector of genotype identifiers.}

\item{YN}{Numeric vector: yield (any trait) under non-stress (normal) environment.}

\item{YS}{Numeric vector: yield (any trait) under stress environment.}

\item{YMN}{Optional numeric scalar: mean of \code{YN}. If NULL, computed.}

\item{YMS}{Optional numeric scalar: mean of \code{YS}. If NULL, computed.}
}
\value{
A list with \code{YMN}, \code{YMS}, and \code{Result} (data frame with \code{Gen}, \code{MRP}).

\deqn{MRP = \left(\frac{YS}{YMS}\right) + \left(\frac{YN}{YMN}\right)}
}
\description{
This function computes Mean Relative Performance (MRP) using any traits (like yield) under stress and non-stress conditions. The lower values of MRP indicates greater tolerance. For more details see Ramirez-Vallejo and Kelly (1998) \url{doi:10.1023/A:1018353200015}.
}
\examples{
out = MRP(
Gen=c("G1","G2","G3"),
YN=c(10,8,5),
YS=c(7,5,3)
)
print(out)
}
\references{
Ramirez-Vallejo, P. and Kelly, J.D. (1998). \url{doi:10.1023/A:1018353200015}.
}
